/*
 * Decompiled with CFR 0.152.
 */
package adql.query.constraint;

public enum ComparisonOperator {
    EQUAL,
    NOT_EQUAL,
    LESS_THAN,
    LESS_OR_EQUAL,
    GREATER_THAN,
    GREATER_OR_EQUAL,
    LIKE,
    NOTLIKE;


    public static ComparisonOperator getOperator(String string) throws UnsupportedOperationException {
        if (string.equalsIgnoreCase("=")) {
            return EQUAL;
        }
        if (string.equalsIgnoreCase("!=") || string.equalsIgnoreCase("<>")) {
            return NOT_EQUAL;
        }
        if (string.equalsIgnoreCase("<")) {
            return LESS_THAN;
        }
        if (string.equalsIgnoreCase("<=")) {
            return LESS_OR_EQUAL;
        }
        if (string.equalsIgnoreCase(">")) {
            return GREATER_THAN;
        }
        if (string.equalsIgnoreCase(">=")) {
            return GREATER_OR_EQUAL;
        }
        if (string.equalsIgnoreCase("LIKE")) {
            return LIKE;
        }
        if (string.equalsIgnoreCase("NOT LIKE")) {
            return NOTLIKE;
        }
        throw new UnsupportedOperationException("Comparison operator unknown: \"" + string + "\" !");
    }

    public String toADQL() {
        switch (this) {
            case EQUAL: {
                return "=";
            }
            case NOT_EQUAL: {
                return "!=";
            }
            case LESS_THAN: {
                return "<";
            }
            case LESS_OR_EQUAL: {
                return "<=";
            }
            case GREATER_THAN: {
                return ">";
            }
            case GREATER_OR_EQUAL: {
                return ">=";
            }
            case LIKE: {
                return "LIKE";
            }
            case NOTLIKE: {
                return "NOT LIKE";
            }
        }
        return "???";
    }

    public String toString() {
        return this.toADQL();
    }
}

